/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.controls.base.IFXValidatableControl;
import com.jfoenix.skins.ValidationPane$$Lambda$1;
import com.jfoenix.skins.ValidationPane$$Lambda$2;
import com.jfoenix.skins.ValidationPane$$Lambda$3;
import com.jfoenix.skins.ValidationPane$$Lambda$4;
import com.jfoenix.skins.ValidationPane$$Lambda$5;
import com.jfoenix.skins.ValidationPane$$Lambda$6;
import com.jfoenix.utils.JFXUtilities;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class ValidationPane<T extends Region & IFXStaticControl>
extends HBox {
    private Label errorLabel = new Label();
    private StackPane errorIcon = new StackPane();
    private final Rectangle errorContainerClip = new Rectangle();
    private final Scale errorClipScale = new Scale(1.0, 0.0, 0.0, 0.0);
    private Timeline errorHideTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Interpolator.LINEAR)})});
    private Timeline errorShowTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Interpolator.EASE_OUT)})});
    private Timeline scale1 = new Timeline();
    private Timeline scaleLess1 = new Timeline();
    private T control;

    public ValidationPane(T control) {
        this.control = control;
        this.setManaged(false);
        this.errorLabel.getStyleClass().add((Object)"error-label");
        this.getChildren().setAll((Object[])new Node[]{new StackPane(new Node[]{this.errorLabel}), this.errorIcon});
        StackPane.setAlignment((Node)this.errorLabel, (Pos)Pos.TOP_LEFT);
        this.setSpacing(8.0);
        this.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)this.errorLabel.getParent(), (Priority)Priority.ALWAYS);
        this.setPadding(new Insets(4.0, 0.0, 0.0, 0.0));
        this.setVisible(false);
        this.setOpacity(0.0);
        this.errorContainerClip.getTransforms().add((Object)this.errorClipScale);
        this.setClip((Node)(((IFXStaticControl)control).isDisableAnimation() != false ? null : this.errorContainerClip));
        ((IFXValidatableControl)control).activeValidatorProperty().addListener(ValidationPane$$Lambda$1.lambdaFactory$(this, control));
    }

    public void layoutPane(double x, double y, double w, double h) {
        this.relocate(x, y);
        if (((IFXStaticControl)this.control).isDisableAnimation().booleanValue() || this.isErrorVisible()) {
            this.resize(w, this.computeErrorHeight(this.computeErrorWidth(w)));
            this.errorContainerClip.setWidth(w);
        }
    }

    public void invalid(double w) {
        ValidatorBase activeValidator = ((IFXValidatableControl)this.control).getActiveValidator();
        if (activeValidator != null) {
            this.showError(activeValidator);
            double errorContainerWidth = w - this.errorIcon.prefWidth(-1.0);
            this.setOpacity(1.0);
            this.resize(w, this.computeErrorHeight(errorContainerWidth));
            this.errorContainerClip.setWidth(w);
            this.errorContainerClip.setHeight(this.getHeight());
            this.errorClipScale.setY(1.0);
        }
    }

    public void updateClip() {
        this.setClip((Node)(((IFXStaticControl)this.control).isDisableAnimation() != false ? null : this.errorContainerClip));
    }

    private boolean isErrorVisible() {
        return this.isVisible() && this.errorShowTransition.getStatus().equals((Object)Animation.Status.STOPPED) && this.errorHideTransition.getStatus().equals((Object)Animation.Status.STOPPED);
    }

    private double computeErrorWidth(double w) {
        return w - this.errorIcon.prefWidth(-1.0);
    }

    private double computeErrorHeight(double errorContainerWidth) {
        return this.errorLabel.prefHeight(errorContainerWidth) + this.snappedBottomInset() + this.snappedTopInset();
    }

    private void updateErrorContainerSize(double w, double errorContainerHeight) {
        this.errorContainerClip.setWidth(w);
        this.errorContainerClip.setHeight(errorContainerHeight);
        this.resize(w, errorContainerHeight);
    }

    private KeyFrame createSmallerScaleFrame(double errorContainerHeight) {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)(errorContainerHeight / this.getHeight()), Interpolator.EASE_BOTH)});
    }

    private KeyFrame createScaleToOneFrames() {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)1, Interpolator.EASE_BOTH)});
    }

    private void showError(ValidatorBase validator) {
        this.errorLabel.setText(validator.getMessage());
        Node icon = validator.getIcon();
        this.errorIcon.getChildren().clear();
        if (icon != null) {
            this.errorIcon.getChildren().setAll((Object[])new Node[]{icon});
            StackPane.setAlignment((Node)icon, (Pos)Pos.CENTER_RIGHT);
        }
        this.setVisible(true);
    }

    private void hideError() {
        this.errorLabel.setText(null);
        this.errorIcon.getChildren().clear();
        this.setVisible(false);
    }

    static /* synthetic */ void lambda$new$4(ValidationPane this_, Region control, ObservableValue o, ValidatorBase oldVal, ValidatorBase newVal) {
        if (!((IFXStaticControl)control).isDisableAnimation().booleanValue()) {
            if (newVal != null) {
                this_.errorHideTransition.setOnFinished(ValidationPane$$Lambda$2.lambdaFactory$(this_, newVal, control, oldVal));
                this_.errorHideTransition.play();
            } else {
                this_.errorHideTransition.setOnFinished(null);
                if (this_.errorLabel.isWrapText()) {
                    this_.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this_.errorClipScale.yProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                    this_.scaleLess1.setOnFinished(ValidationPane$$Lambda$3.lambdaFactory$(this_));
                    SequentialTransition transition = new SequentialTransition(new Animation[]{this_.scaleLess1});
                    transition.play();
                } else {
                    this_.errorClipScale.setY(0.0);
                }
                this_.errorHideTransition.play();
            }
        } else if (newVal != null) {
            JFXUtilities.runInFXAndWait(ValidationPane$$Lambda$4.lambdaFactory$(this_, newVal));
        } else {
            JFXUtilities.runInFXAndWait(ValidationPane$$Lambda$5.lambdaFactory$(this_));
        }
    }

    static /* synthetic */ void lambda$null$3(ValidationPane this_, ValidatorBase newVal) {
        this_.showError(newVal);
    }

    static /* synthetic */ void lambda$null$2(ValidationPane this_, ActionEvent event) {
        this_.hideError();
        this_.errorClipScale.setY(0.0);
    }

    static /* synthetic */ void lambda$null$1(ValidationPane this_, ValidatorBase newVal, Region control, ValidatorBase oldVal, ActionEvent finish) {
        this_.showError(newVal);
        double w = control.getWidth();
        double errorContainerHeight = this_.computeErrorHeight(this_.computeErrorWidth(w));
        if (this_.errorLabel.isWrapText()) {
            if (errorContainerHeight < this_.getHeight()) {
                this_.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{this_.createSmallerScaleFrame(errorContainerHeight)});
                this_.scaleLess1.setOnFinished(ValidationPane$$Lambda$6.lambdaFactory$(this_, w, errorContainerHeight));
                SequentialTransition transition = new SequentialTransition(new Animation[]{this_.scaleLess1, this_.errorShowTransition});
                transition.play();
            } else {
                this_.errorClipScale.setY(oldVal == null ? 0.0 : this_.getHeight() / errorContainerHeight);
                this_.updateErrorContainerSize(w, errorContainerHeight);
                this_.scale1.getKeyFrames().setAll((Object[])new KeyFrame[]{this_.createScaleToOneFrames()});
                ParallelTransition parallelTransition = new ParallelTransition();
                parallelTransition.getChildren().addAll((Object[])new Animation[]{this_.scale1, this_.errorShowTransition});
                parallelTransition.play();
            }
        } else {
            this_.errorClipScale.setY(1.0);
            this_.updateErrorContainerSize(w, errorContainerHeight);
            ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this_.errorShowTransition});
            parallelTransition.play();
        }
    }

    static /* synthetic */ void lambda$null$0(ValidationPane this_, double w, double errorContainerHeight, ActionEvent event) {
        this_.updateErrorContainerSize(w, errorContainerHeight);
        this_.errorClipScale.setY(1.0);
    }

    static /* synthetic */ void access$lambda$0(ValidationPane validationPane) {
        validationPane.hideError();
    }
}

